#if NUNIT
#region Directives
//-----------------------***
using System;
using System.Collections;
using System.Data;
using System.Text;
using NUnit.Framework;
using gov.va.med.vbecs.UnitTests;

using TABLES = gov.va.med.vbecs.Common.VbecsTables;
using SPROCS = gov.va.med.vbecs.Common.VbecsStoredProcs;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;


using BOL = gov.va.med.vbecs.BOL;
using COMMON = gov.va.med.vbecs.Common;
using DAL = gov.va.med.vbecs.DAL;
using VAL = gov.va.med.vbecs.VAL;
using gov.va.med.vbecs.VAL.UnitTests;
//-----------------------***
#endregion

namespace gov.va.med.vbecs.BOL.UnitTests
{

	
	

	[TestFixture]
	public class BOL_EquipmentMaintenance : BaseTest 
	{
		private BOL.EquipmentMaintenance _tstEQM;
		private BOL.Equipment _tstEQ;
		private DataTable _dtEquipment; 
		private DataRow _drEQM;
		private DataTable _dtEquipmentMaintenance;
		private BOL.EquipmentMaintenance _blankEQM;


		[SetUp]
		protected void SetUp()
		{
			this.BaseSetUp();

			if (this.RefreshData)
			{
				this._dtEquipment= UnitTestUtil.RunSQLGetDataTable("SELECT TOP 5 * FROM Equipment WHERE DivisionCode='" + this.TestDivisionCode + "'");
				this._tstEQ=new Equipment(this._dtEquipment.Rows[0]);

				try
				{
					this._dtEquipmentMaintenance = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 EquipmentMaintenance.* FROM EquipmentMaintenance JOIN Equipment ON Equipment.EquipmentGuid = EquipmentMaintenance.EquipmentGuid WHERE DivisionCode = '" + this.TestDivisionCode + "'", true);
				}
				catch(BOL.BusinessObjectException)
				{
					this._dtEquipmentMaintenance=DAL.EquipmentMaintenance.GetEmptyEquipmentMaintenanceTable();
					
					this._drEQM=this._dtEquipmentMaintenance.NewRow();
					this._drEQM[TABLES.EquipmentMaintenance.EquipmentMaintenanceGuid]=System.Guid.NewGuid();
					this._drEQM[TABLES.EquipmentMaintenance.EquipmentGuid]=this._tstEQ.EquipmentGuid;
					this._drEQM[TABLES.EquipmentMaintenance.MaintenanceDate]=DateTime.Now.AddDays(-5);
					this._drEQM[TABLES.EquipmentMaintenance.MaintenanceResults]="UnitTest";
					this._drEQM[TABLES.EquipmentMaintenance.MaintenanceType]="UnitTest";
					this._drEQM[TABLES.EquipmentMaintenance.PendingIssues]="UnitTest";
					this._drEQM[TABLES.Equipment.DivisionCode]=UnitTestConfig.TestDivisionCode;
					this._dtEquipmentMaintenance.Rows.Add(this._drEQM);

					DAL.EquipmentMaintenance.Save(this._dtEquipmentMaintenance, DAL.EquipmentMaintenance.GetEmptyEquipmentMaintenanceTable(), Common.UpdateFunction.UC022_FrmMaintainEquipment);

					this.SetUp();	//Calling a method within itself??? interesting
				}
				//Need to do this so the EquipmentMaintenanceDate is converted into local time
				this._dtEquipmentMaintenance = BOL.EquipmentMaintenance.GetEquipmentMaintenance((System.Guid)this._dtEquipmentMaintenance.Rows[0][TABLES.EquipmentMaintenance.EquipmentGuid]);

				if(_dtEquipmentMaintenance.Rows.Count>0)
				{
					this._drEQM = this._dtEquipmentMaintenance.Rows[0];
					this._tstEQM = new BOL.EquipmentMaintenance((System.Guid)this._drEQM[TABLES.EquipmentMaintenance.EquipmentMaintenanceGuid]);
				}
				else
				{
					this._drEQM = this._dtEquipmentMaintenance.NewRow();
					this._tstEQM = new BOL.EquipmentMaintenance(System.Guid.NewGuid());
					this._tstEQM.EquipmentGuid=this._tstEQ.EquipmentGuid;
				}

				this.RefreshData = false;

				BOL.EquipmentMaintenance em=new EquipmentMaintenance(System.Guid.NewGuid());
				this._blankEQM = new BOL.EquipmentMaintenance(DAL.EquipmentMaintenance.GetEmptyEquipmentMaintenanceTable().NewRow());
			}

		}

		[TearDown]
		protected void TearDown()
		{
		}

		[Test]
		public void Ctor_GUID_Pass()
		{
			BOL.EquipmentMaintenance tmpEQM = new BOL.EquipmentMaintenance(this._tstEQM.EquipmentMaintenceGuid);
			
			Assert.AreEqual(this._tstEQM.EquipmentMaintenceGuid, tmpEQM.EquipmentMaintenceGuid, "EquipmentMaintenceGuid");
			Assert.AreEqual(this._tstEQM.EquipmentGuid, tmpEQM.EquipmentGuid, "EquipmentGuid");
			Assert.AreEqual(this._tstEQM.MaintenanceActivity, tmpEQM.MaintenanceActivity, "MaintenanceActivity");
			Assert.AreEqual(this._tstEQM.MaintenanceDate, tmpEQM.MaintenanceDate, "MainenanceDate");
			Assert.AreEqual(this._tstEQM.MaintenanceResult, tmpEQM.MaintenanceResult, "MaintenanceResult");
			Assert.AreEqual(this._tstEQM.PendingMaintenanceIssues, tmpEQM.PendingMaintenanceIssues, "PendingMaintenanceIssues");
		}

		[Test]
		[ExpectedException(typeof(ArgumentException))]
		public void Ctor_GUID_Fail()
		{
			BOL.EquipmentMaintenance tmpEQM = new BOL.EquipmentMaintenance(System.Guid.Empty);
		}

		[Test]
		public void Ctor_DataRow_Pass()
		{
			BOL.EquipmentMaintenance tmpEQM = new BOL.EquipmentMaintenance(this._drEQM);

			Assert.AreEqual((Guid)this._drEQM[TABLES.EquipmentMaintenance.EquipmentMaintenanceGuid], tmpEQM.EquipmentMaintenceGuid, "EquipmentMaintenceGuid");
			Assert.AreEqual((Guid)this._drEQM[TABLES.EquipmentMaintenance.EquipmentGuid], tmpEQM.EquipmentGuid, "EquipmentGuid");
			Assert.AreEqual(this._drEQM[TABLES.EquipmentMaintenance.MaintenanceType].ToString(), tmpEQM.MaintenanceActivity, "MaintenanceActivity");
			Assert.AreEqual(this._drEQM[TABLES.EquipmentMaintenance.MaintenanceResults].ToString(), tmpEQM.MaintenanceResult, "MaintenanceResult");
			Assert.AreEqual(this._drEQM[TABLES.EquipmentMaintenance.PendingIssues].ToString(), tmpEQM.PendingMaintenanceIssues, "PendingMaintenanceIssues");
		}

		[Test]
		[ExpectedException(typeof(ArgumentException))]
		public void Ctor_DataRow_Fail()
		{
			DataTable dtTest = new DataTable();
			dtTest.Columns.Add(TABLES.EquipmentMaintenance.EquipmentMaintenanceGuid, typeof(System.Guid));

			BOL.EquipmentMaintenance tmpEQM = new BOL.EquipmentMaintenance(dtTest.NewRow());
		}

		[Test]
		public void GetEmptyEquipmentMaintenanceTable_Pass()
		{
			DataTable dt = BOL.EquipmentMaintenance.GetEmptyEquipmentMaintenanceTable();

			//a fAILURE HERE MEANS THERE WAS A DB CHANGE
			Assert.AreEqual(8, dt.Columns.Count, "Columns.Count");
		}

		[Test]
		[Ignore( StandardIgnoreReasons.NoFailureConditions )]
		public void GetEmptyEquipmentMaintenanceTable_Fail()
		{
		}

		[Test]
		public void EquipmentMaintenanceGuid_Pass()
		{
			System.Guid tmpValue = System.Guid.NewGuid();
			
			BOL.EquipmentMaintenance tmpEquipmentMaintenance = new EquipmentMaintenance(tmpValue);

			Assert.AreEqual(tmpValue, tmpEquipmentMaintenance.EquipmentMaintenceGuid,"Valid Value");

			//Testing a Null Column
			Assert.AreEqual(System.Guid.Empty, this._blankEQM.EquipmentMaintenceGuid, "Null Column");
		}

		[Test]
		[Ignore( StandardIgnoreReasons.ReadOnlyProperty)]
		public void EquipmentMaintenanceGuid_Fail()
		{
		}

		[Test]
		public void EquipmentGuid_Pass()
		{
			Guid tmpValue = Guid.NewGuid();

			_tstEQM.EquipmentGuid = tmpValue;

			Assert.AreEqual(tmpValue, _tstEQM.EquipmentGuid, "Valid Value");

			//Testing a Null Column
			Assert.AreEqual(System.Guid.Empty, this._blankEQM.EquipmentGuid, "Null Column");
		}

		[Test]
		[Ignore( StandardIgnoreReasons.NoFailureConditions )]
		public void EquipmentGuid_Fail()
		{
			
		}

		[Test]
		public void MaintenanceActivity_Pass()
		{
			string tmpValue = "".PadRight(50,'X');

			_tstEQM.MaintenanceActivity = tmpValue;

			Assert.AreEqual(tmpValue, this._tstEQM.MaintenanceActivity, "Valid Value");

			//Testing a Null Column
			Assert.AreEqual(String.Empty, this._blankEQM.MaintenanceActivity, "Null Column");
		}

		[Test]
		[ExpectedException(typeof(ArgumentException))]
		public void MaintenanceActivity_Fail()
		{
			_tstEQM.MaintenanceActivity = "".PadRight(51,'X');
		}

		[Test]
		public void MaintenanceDate_Pass()
		{
			DateTime tmpValue = BOL.VBECSDateTime.GetDivisionCurrentDateTime();

			_tstEQM.MaintenanceDate = tmpValue;

			Assert.AreEqual(tmpValue, this._tstEQM.MaintenanceDate, "Valid Value");

			//Testing a Null Column
			Assert.AreEqual(System.DateTime.MinValue, this._blankEQM.MaintenanceDate, "Null Column");
		}

		[Test]
		[ExpectedException(typeof(ArgumentException))]
		public void MaintenanceDate_Fail()
		{
			DateTime tmpValue = BOL.VBECSDateTime.GetDivisionCurrentDateTime().AddMinutes(1);

			_tstEQM.MaintenanceDate = tmpValue;

			Assert.AreEqual(tmpValue, this._tstEQM.MaintenanceDate, "Valid Value");
		}

		[Test]
		public void MaintenanceResult_Pass()
		{
			string tmpValue = "".PadRight(255,'X');

			_tstEQM.MaintenanceResult = tmpValue;

			Assert.AreEqual(tmpValue, this._tstEQM.MaintenanceResult, "Valid Value");
			
			//Testing a Null Column
			Assert.AreEqual(string.Empty, this._blankEQM.MaintenanceResult, "Null Column");
		}

		[Test]
		[ExpectedException(typeof(ArgumentException))]
		public void MaintenanceResult_Fail()
		{
			_tstEQM.MaintenanceResult = "".PadRight(256,'X');
		}

		[Test]
		public void PendingMaintenanceIssues_Pass()
		{
			string tmpValue = "".PadRight(255,'X');

			_tstEQM.PendingMaintenanceIssues = tmpValue;

			Assert.AreEqual(tmpValue, this._tstEQM.PendingMaintenanceIssues, "Valid Value");
			
			//Testing a Null Column
			Assert.AreEqual(string.Empty, this._blankEQM.PendingMaintenanceIssues, "Null Column");
		}

		[Test]
		[ExpectedException(typeof(ArgumentException))]
		public void PendingMaintenanceIssues_Fail()
		{
			_tstEQM.PendingMaintenanceIssues = "".PadRight(256,'X');
		}

		[Test]
		public void LoadDataRowFromThis_Pass()
		{
			DataRow dr = _tstEQM.LoadDataRowFromThis(this._drEQM.Table.NewRow());

			Assert.AreEqual(_tstEQM.MaintenanceResult, dr[TABLES.EquipmentMaintenance.MaintenanceResults].ToString(), "MaintenanceResults");
			Assert.AreEqual(_tstEQM.MaintenanceActivity, dr[TABLES.EquipmentMaintenance.MaintenanceType].ToString(), "MaintenanceType");
			Assert.AreEqual(_tstEQM.PendingMaintenanceIssues, dr[TABLES.EquipmentMaintenance.PendingIssues].ToString(), "PendingIssues");
		}

		[Test]
		[Ignore( StandardIgnoreReasons.NoFailureConditions )]
		public void LoadDataRowFromThis_Fail()
		{
		}

		[Test]
		public void GetEquipmentMaintenance_Pass()
		{
			DataTable dt = BOL.EquipmentMaintenance.GetEquipmentMaintenance();
			Assert.AreEqual(true, dt.Rows.Count>0, "Rows.Count");
		}

		[Test]
		public void GetEquipmentMaintenance_Fail()
		{
			Common.LogonUser.LogonUserDivisionCode = "XXXXX";
			
			DataTable dt = BOL.EquipmentMaintenance.GetEquipmentMaintenance();
			Assert.AreEqual(0, dt.Rows.Count, "Rows.Count");
		}

		[Test]
		public void GetEquipmentMaintenance_Guid_Pass()
		{
			this._tstEQM=new EquipmentMaintenance(this._dtEquipmentMaintenance.Rows[0]);
			DataTable dt = BOL.EquipmentMaintenance.GetEquipmentMaintenance((Guid)this._dtEquipmentMaintenance.Rows[0][TABLES.EquipmentMaintenance.EquipmentGuid]);
			
			Assert.AreEqual(true, dt.Rows.Count>0, "Rows.Count");
			Assert.AreEqual(_tstEQM.EquipmentGuid, (Guid)dt.Rows[0][TABLES.EquipmentMaintenance.EquipmentGuid], "EquipmentGuid");
		}

		[Test]
		[ExpectedException(typeof(ArgumentException))]
		public void GetEquipmentMaintenance_Guid_Fail()
		{
			DataTable dt = BOL.EquipmentMaintenance.GetEquipmentMaintenance(Guid.Empty);
			Assert.AreEqual(0, dt.Rows.Count, "Rows.Count");
		}

		[Test]
		public void Save_Pass()
		{
			this.RefreshData = true;

			this._drEQM=this._dtEquipmentMaintenance.NewRow();
			
			this._drEQM[TABLES.EquipmentMaintenance.EquipmentMaintenanceGuid]=System.Guid.NewGuid();
			this._drEQM[TABLES.EquipmentMaintenance.EquipmentGuid]=this._tstEQ.EquipmentGuid;
			this._drEQM[TABLES.EquipmentMaintenance.MaintenanceDate]=DateTime.Now.AddDays(-5);
			this._drEQM[TABLES.EquipmentMaintenance.MaintenanceResults]="UnitTest";
			this._drEQM[TABLES.EquipmentMaintenance.MaintenanceType]="UnitTest";
			this._drEQM[TABLES.EquipmentMaintenance.PendingIssues]="UnitTest";
			this._drEQM[TABLES.Equipment.DivisionCode]=UnitTestConfig.TestDivisionCode;
			
			this._dtEquipmentMaintenance.Rows.Add(this._drEQM);

			_dtEquipmentMaintenance.AcceptChanges();
			
			bool rc = BOL.EquipmentMaintenance.Save(_dtEquipmentMaintenance,Common.UpdateFunction.UnitTests);
			Assert.AreEqual(true, rc, "ReturnCode");
		}

		[Test]
        [ExpectedException(typeof(Common.UniqueDatabaseConstraintViolatedException))]
		public void Save_Fail()
		{
			//Attempt to insert a duplicate row
			DataRow drEM = _dtEquipmentMaintenance.NewRow();
			_drEQM=_dtEquipmentMaintenance.Rows[0];

			drEM.ItemArray = _drEQM.ItemArray;
			drEM[TABLES.EquipmentMaintenance.RowVersion] = DBNull.Value;
			
			_dtEquipmentMaintenance.Rows.Add(drEM);
			
			BOL.EquipmentMaintenance.Save(_dtEquipmentMaintenance,Common.UpdateFunction.UnitTests);
		}

		[Test]
		public void GetMaintenanceTypes_Pass()
		{
			System.Collections.ArrayList tmpList = BOL.EquipmentMaintenance.GetMaintenanceTypes();

			Assert.AreEqual(true, tmpList.Count > 0, "Count");
		}

		[Test]
		public void GetMaintenanceTypes_Fail()
		{
			Common.LogonUser.LogonUserDivisionCode = "XXXXX";

			System.Collections.ArrayList tmpList = BOL.EquipmentMaintenance.GetMaintenanceTypes();

			Assert.AreEqual(0, tmpList.Count, "Count");
		}

	}
}

#endif
